<?php
require_once __DIR__ . '/../includes/_init.php';
require_auth();
post_only();
csrf_verify();

$pdo = db();
$tripId = (int)($_POST['trip_id'] ?? 0);
$placeId = (int)($_POST['place_id'] ?? 0);

try {
  $st = $pdo->prepare("SELECT id FROM trips WHERE id=? AND user_id=?");
  $st->execute([$tripId, (int)$_SESSION['user_id']]);
  if (!$st->fetch()) throw new Exception('Trip not found.');

  $pdo->prepare("UPDATE trip_places SET selected_flag=0 WHERE trip_id=? AND place_id=?")->execute([$tripId, $placeId]);

  set_flash('success','Place removed. Regenerating route...');
  // Redirect via regenerate endpoint
  start_session();
  $_SESSION['_regen_trip_id'] = $tripId;
  redirect('/user/remove_place_regen.php');

} catch (Exception $ex) {
  set_flash('danger', $ex->getMessage());
  redirect('/user/trip_view.php?id=' . $tripId);
}
