<?php
require_once __DIR__ . '/../includes/_init.php';
require_auth();

$pdo = db();
$cats = $pdo->query("SELECT * FROM categories WHERE is_active=1 ORDER BY name")->fetchAll();

$pageTitle = "Create Trip";
include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/navbar_user.php';
?>
<div class="container py-4">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-lg-7">
      <div class="form-card p-4">
        <div class="d-flex justify-content-between align-items-start gap-3">
          <div>
            <div class="h4 fw-bold mb-1">Build your day plan</div>
            <div class="text-muted">City → preferences → route → itinerary (1-day trip).</div>
          </div>
          <span class="badge bg-primary-subtle text-primary border border-primary-subtle rounded-pill">Wizard</span>
        </div>

        <hr class="border border-light border-opacity-10">

        <form method="post" action="<?= BASE_URL ?>/user/generate_trip.php" class="vstack gap-3">
          <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">

          <div class="row g-3">
            <div class="col-md-7">
              <label class="form-label">Trip name</label>
              <input class="form-control" name="trip_name" required placeholder="e.g., Mumbai Day Out">
            </div>
            <div class="col-md-5">
              <label class="form-label">City</label>
              <input class="form-control" name="city" required placeholder="e.g., Mumbai">
              <div class="small-note mt-1">City will be validated via geocoding.</div>
            </div>
          </div>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Start time</label>
              <input type="time" class="form-control" name="start_time" value="10:00" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">End time</label>
              <input type="time" class="form-control" name="end_time" value="18:00" required>
            </div>
          </div>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Starting location</label>
              <input class="form-control" name="start_location" placeholder="Use current location OR type a place">
              <div class="small-note mt-1">
                If empty, the system will use city center as start point.
              </div>
            </div>
            <div class="col-md-6">
              <label class="form-label">Travel pace</label>
              <select class="form-select" name="pace">
                <option value="relaxed">Relaxed</option>
                <option value="normal" selected>Normal</option>
                <option value="fast">Fast</option>
              </select>
            </div>
          </div>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Budget preference (optional)</label>
              <select class="form-select" name="budget">
                <option value="">Not specified</option>
                <option value="low">Low</option>
                <option value="medium" selected>Medium</option>
                <option value="high">High</option>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">Average visit time per place</label>
              <select class="form-select" name="visit_minutes">
                <option value="30">30 minutes</option>
                <option value="60" selected>60 minutes</option>
                <option value="90">90 minutes</option>
              </select>
            </div>
          </div>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Max places (5–12)</label>
              <input type="number" class="form-control" name="max_places" min="5" max="12" value="8" required>
              <div class="small-note mt-1">Keeps results controllable for a minor project.</div>
            </div>
            <div class="col-md-6">
              <label class="form-label">Constraints</label>
              <div class="form-check mt-2">
                <input class="form-check-input" type="checkbox" name="avoid_long_travel" value="1" id="avoidLong">
                <label class="form-check-label" for="avoidLong">Avoid long travel (filters far places)</label>
              </div>
            </div>
          </div>

          <div class="mt-2">
            <label class="form-label">Interests</label>
            <div class="row g-2">
              <?php foreach ($cats as $c): ?>
                <div class="col-6 col-md-4">
                  <label class="feature-card p-3 d-flex gap-2 align-items-center">
                    <input class="form-check-input mt-0" type="checkbox" name="categories[]" value="<?= (int)$c['id'] ?>">
                    <div>
                      <div class="fw-semibold"><?= e($c['name']) ?></div>
                      <div class="text-muted small"><?= e($c['slug']) ?></div>
                    </div>
                  </label>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="small-note mt-2">Tip: choose 3–5 interests for best results.</div>
          </div>

          <div class="mt-2">
            <label class="form-label">Describe your mood (optional)</label>
            <textarea class="form-control" name="mood" rows="2" placeholder="e.g., calm places, good food, less crowd"></textarea>
            <div class="small-note mt-1">This auto-maps keywords to interests (minor-project AI).</div>
          </div>

          <button class="btn btn-primary btn-lg mt-2">
            <i class="fa-solid fa-wand-magic-sparkles me-2"></i>Generate Plan
          </button>
        </form>
      </div>
    </div>

    <div class="col-lg-5">
      <div class="form-card p-4">
        <div class="h5 fw-semibold">What you’ll get</div>
        <ul class="text-muted mt-2">
          <li>Top ranked places based on interests + rating + distance</li>
          <li>Optimized route order (nearest-neighbor on travel times)</li>
          <li>Auto itinerary schedule with travel & visit blocks</li>
          <li>Interactive map with route polyline and markers</li>
          <li>Saved trip you can reopen later</li>
        </ul>
        <hr class="border border-light border-opacity-10">
        <div class="small-note">
          If you see API errors, add keys in <code>app/config.php</code>.
        </div>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
