<?php
require_once __DIR__ . '/includes/_init.php';
$pageTitle = "Smart Tourist Guide";
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/navbar_public.php';
?>
<section class="hero py-5">
  <div class="container py-4">
    <div class="row align-items-center g-4">
      <div class="col-lg-6">
        <span class="badge badge-soft rounded-pill px-3 py-2">Minor Project • Business UI • Real APIs</span>
        <h1 class="display-5 fw-bold mt-3">Plan a perfect day in any city — automatically.</h1>
        <p class="lead text-muted mt-3">
          SmartGuide finds the best places, builds an optimized route, and generates a time-wise itinerary —
          all in a few clicks.
        </p>
        <div class="d-flex gap-2 mt-4">
          <a class="btn btn-primary btn-lg" href="<?= BASE_URL ?>/auth/signup.php">Create Your Trip</a>
          <a class="btn btn-outline-light btn-lg" href="<?= BASE_URL ?>/auth/login.php">Login</a>
        </div>
        <div class="small-note mt-3">
          Powered by OpenStreetMap + OpenTripMap + OpenRouteService (free-friendly stack).
        </div>
      </div>
      <div class="col-lg-6">
        <div class="hero-card p-4">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <div class="text-uppercase small text-muted">Preview</div>
              <div class="h4 fw-semibold mt-1">Optimized Day Plan</div>
              <div class="text-muted">City • Places • Route • Itinerary</div>
            </div>
            <span class="badge bg-success-subtle text-success border border-success-subtle rounded-pill">Live Flow</span>
          </div>
          <hr class="border border-light border-opacity-10">
          <div class="row g-3">
            <div class="col-6">
              <div class="feature-card p-3 h-100">
                <div class="fw-semibold"><i class="fa-solid fa-location-dot me-2 text-primary"></i>City validated</div>
                <div class="text-muted small mt-1">Nominatim geocoding ensures the city exists.</div>
              </div>
            </div>
            <div class="col-6">
              <div class="feature-card p-3 h-100">
                <div class="fw-semibold"><i class="fa-solid fa-magnifying-glass me-2 text-success"></i>Places discovered</div>
                <div class="text-muted small mt-1">Fetch by categories like cafe, museum, nature.</div>
              </div>
            </div>
            <div class="col-6">
              <div class="feature-card p-3 h-100">
                <div class="fw-semibold"><i class="fa-solid fa-route me-2 text-warning"></i>Route optimized</div>
                <div class="text-muted small mt-1">Nearest-neighbor heuristic on real travel times.</div>
              </div>
            </div>
            <div class="col-6">
              <div class="feature-card p-3 h-100">
                <div class="fw-semibold"><i class="fa-solid fa-calendar-check me-2 text-info"></i>Itinerary built</div>
                <div class="text-muted small mt-1">Auto schedule with travel + visit blocks.</div>
              </div>
            </div>
          </div>
          <div class="mt-3 text-muted small">
            Note: Set API keys in <code>app/config.php</code> for live results.
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="features" class="py-5">
  <div class="container">
    <div class="d-flex align-items-end justify-content-between gap-3 mb-4">
      <div>
        <h2 class="section-title fw-bold">Business-level features</h2>
        <p class="text-muted mb-0">Everything needed for a complete minor project submission.</p>
      </div>
      <a class="btn btn-outline-light" href="<?= BASE_URL ?>/auth/signup.php">Start Now</a>
    </div>

    <div class="row g-3">
      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="h5 fw-semibold"><i class="fa-solid fa-user-shield me-2"></i>Secure Accounts</div>
          <div class="text-muted">Signup/login with bcrypt hashing, sessions, and CSRF protection.</div>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="h5 fw-semibold"><i class="fa-solid fa-sliders me-2"></i>Preferences</div>
          <div class="text-muted">Interests, budget, pace, time window, max places, avoid long travel.</div>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="h5 fw-semibold"><i class="fa-solid fa-brain me-2"></i>Smart Ranking</div>
          <div class="text-muted">Rule-based scoring + optional “mood text” to auto-select interests.</div>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="h5 fw-semibold"><i class="fa-solid fa-map-location-dot me-2"></i>Interactive Map</div>
          <div class="text-muted">Leaflet + OSM markers, numbered route stops, polyline route.</div>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="h5 fw-semibold"><i class="fa-solid fa-floppy-disk me-2"></i>Saved Trips</div>
          <div class="text-muted">Store plans in DB and reopen anytime with map + schedule.</div>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="h5 fw-semibold"><i class="fa-solid fa-screwdriver-wrench me-2"></i>Admin Panel</div>
          <div class="text-muted">Manage categories mapping to API types, view users and trips.</div>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="how" class="py-5 border-top border-light border-opacity-10">
  <div class="container">
    <h2 class="section-title fw-bold mb-4">How it works</h2>
    <div class="row g-3">
      <div class="col-lg-3">
        <div class="feature-card p-4 h-100">
          <div class="fw-semibold">1) Choose City</div>
          <div class="text-muted small mt-1">City validated using geocoding.</div>
        </div>
      </div>
      <div class="col-lg-3">
        <div class="feature-card p-4 h-100">
          <div class="fw-semibold">2) Select Interests</div>
          <div class="text-muted small mt-1">Categories + constraints for a controllable plan.</div>
        </div>
      </div>
      <div class="col-lg-3">
        <div class="feature-card p-4 h-100">
          <div class="fw-semibold">3) Optimize Route</div>
          <div class="text-muted small mt-1">Real travel-time matrix + nearest-neighbor ordering.</div>
        </div>
      </div>
      <div class="col-lg-3">
        <div class="feature-card p-4 h-100">
          <div class="fw-semibold">4) Save & Reopen</div>
          <div class="text-muted small mt-1">Trip stored as JSON in DB (route + schedule).</div>
        </div>
      </div>
    </div>

    <div class="mt-4 text-muted small">
      For live place/routing results, configure API keys in <code>app/config.php</code>.
    </div>
  </div>
</section>

<footer class="py-4 border-top border-light border-opacity-10">
  <div class="container d-flex flex-wrap justify-content-between align-items-center gap-2">
    <div class="text-muted small">© <?= date('Y') ?> SmartGuide • Educational project template</div>
    <div class="d-flex gap-2">
      <a class="text-muted small" href="<?= BASE_URL ?>/admin/login.php">Admin</a>
      <span class="text-muted small">•</span>
      <a class="text-muted small" href="<?= BASE_URL ?>/auth/login.php">User</a>
    </div>
  </div>
</footer>

<?php include __DIR__ . '/includes/footer.php'; ?>
