<?php
require_once __DIR__ . '/../includes/_init.php';
require_once __DIR__ . '/../../app/helpers.php';
require_once __DIR__ . '/../../app/db.php';

$pageTitle = "Login";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $email = strtolower(trim($_POST['email'] ?? ''));
  $password = (string)($_POST['password'] ?? '');

  if ($email === '' || $password === '') {
    set_flash('danger', 'Email and password are required.');
    redirect('/auth/login.php');
  }

  $pdo = db();
  $st = $pdo->prepare("SELECT id, password_hash, name FROM users WHERE email=? LIMIT 1");
  $st->execute([$email]);
  $u = $st->fetch();

  if (!$u || !password_verify($password, $u['password_hash'])) {
    set_flash('danger', 'Invalid credentials.');
    redirect('/auth/login.php');
  }

  start_session();
  $_SESSION['user_id'] = (int)$u['id'];
  $_SESSION['user_name'] = $u['name'];
  set_flash('success', 'Welcome back, ' . $u['name'] . '!');
  redirect('/user/dashboard.php');
}

include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/navbar_public.php';
?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-6">
      <div class="form-card p-4">
        <h3 class="fw-bold mb-1">Login</h3>
        <div class="text-muted mb-4">Access your saved trips and create new itineraries.</div>

        <?php if ($flash): ?>
          <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
        <?php endif; ?>

        <form method="post" class="vstack gap-3">
          <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
          <div>
            <label class="form-label">Email</label>
            <input class="form-control" name="email" required placeholder="name@example.com">
          </div>
          <div>
            <label class="form-label">Password</label>
            <input type="password" class="form-control" name="password" required placeholder="Your password">
          </div>
          <button class="btn btn-primary btn-lg">Login</button>
          <div class="text-muted small">
            New here? <a href="<?= BASE_URL ?>/auth/signup.php" class="text-decoration-underline">Create an account</a>
          </div>
        </form>

        <hr class="border border-light border-opacity-10 mt-4">
        <div class="small-note">
          Demo user: <code>demo@smartguide.local</code> / <code>User@123</code>
        </div>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
