<?php
require_once __DIR__ . '/includes/admin_init.php';
require_admin();

$pdo = db();
$rows = $pdo->query("SELECT t.id,t.trip_name,t.city,t.created_at,u.name AS user_name,
                    (SELECT COUNT(*) FROM trip_places tp WHERE tp.trip_id=t.id AND tp.selected_flag=1) AS places_count
                    FROM trips t JOIN users u ON u.id=t.user_id
                    ORDER BY t.created_at DESC")->fetchAll();

$pageTitle = "Trips";
$active = "trips";
include __DIR__ . '/includes/admin_layout_top.php';
include __DIR__ . '/includes/admin_sidebar.php';
?>
<main class="admin-main">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-3">
    <div>
      <div class="text-muted small">Records</div>
      <h2 class="fw-bold mb-0">Trips</h2>
    </div>
    <div class="text-muted small"><?= count($rows) ?> trips</div>
  </div>

  <div class="card p-4">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead>
          <tr>
            <th>Trip</th><th>User</th><th>City</th><th>Places</th><th>Created</th><th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $t): ?>
            <tr>
              <td class="fw-semibold"><?= e($t['trip_name']) ?></td>
              <td><?= e($t['user_name']) ?></td>
              <td><?= e($t['city']) ?></td>
              <td><?= (int)$t['places_count'] ?></td>
              <td class="text-muted"><?= e(date('d M Y', strtotime($t['created_at']))) ?></td>
              <td class="text-end">
                <a class="btn btn-outline-light btn-sm" href="<?= BASE_URL ?>/admin/trip_view.php?id=<?= (int)$t['id'] ?>">Open</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</main>
<?php include __DIR__ . '/includes/admin_layout_bottom.php'; ?>
