<?php
require_once __DIR__ . '/includes/admin_init.php';
require_admin();

$pdo = db();
$tripId = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("SELECT t.*, u.name AS user_name, u.email AS user_email
                     FROM trips t JOIN users u ON u.id=t.user_id
                     WHERE t.id=?");
$st->execute([$tripId]);
$trip = $st->fetch();
if (!$trip) { set_flash('danger','Trip not found.'); redirect('/admin/trips.php'); }

$places = $pdo->prepare("SELECT pm.name, pm.lat, pm.lng, pm.rating, c.name AS category
                         FROM trip_places tp
                         JOIN places_master pm ON pm.id=tp.place_id
                         JOIN categories c ON c.id=tp.category_id
                         WHERE tp.trip_id=? AND tp.selected_flag=1");
$places->execute([$tripId]);
$places = $places->fetchAll();

$routeRow = $pdo->prepare("SELECT total_distance_m,total_time_s FROM trip_route WHERE trip_id=?");
$routeRow->execute([$tripId]);
$route = $routeRow->fetch();

$pageTitle = "Trip Details";
$active = "trips";
include __DIR__ . '/includes/admin_layout_top.php';
include __DIR__ . '/includes/admin_sidebar.php';
?>
<main class="admin-main">
  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <div class="text-muted small">Trip Detail</div>
      <h2 class="fw-bold mb-1"><?= e($trip['trip_name']) ?></h2>
      <div class="text-muted">
        User: <?= e($trip['user_name']) ?> (<?= e($trip['user_email']) ?>) • City: <?= e($trip['city']) ?>
      </div>
    </div>
    <a class="btn btn-outline-light" href="<?= BASE_URL ?>/admin/trips.php"><i class="fa-solid fa-arrow-left me-2"></i>Back</a>
  </div>

  <div class="row g-3">
    <div class="col-md-4">
      <div class="card p-4">
        <div class="text-muted small">Created</div>
        <div class="h5 fw-semibold mb-0"><?= e(date('d M Y, H:i', strtotime($trip['created_at']))) ?></div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card p-4">
        <div class="text-muted small">Places</div>
        <div class="h5 fw-semibold mb-0"><?= count($places) ?></div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card p-4">
        <div class="text-muted small">Route Summary</div>
        <div class="h6 mb-0">
          <?= $route ? number_format(($route['total_distance_m']/1000), 1).' km' : '—' ?> •
          <?= $route ? gmdate('H:i', (int)$route['total_time_s']) : '—' ?>
        </div>
      </div>
    </div>
  </div>

  <div class="card p-4 mt-3">
    <div class="h5 fw-semibold mb-3">Selected Places</div>
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead>
          <tr><th>Name</th><th>Category</th><th>Rating</th><th>Lat/Lng</th></tr>
        </thead>
        <tbody>
          <?php foreach ($places as $p): ?>
            <tr>
              <td class="fw-semibold"><?= e($p['name']) ?></td>
              <td class="text-muted"><?= e($p['category']) ?></td>
              <td><?= $p['rating'] ? e((string)$p['rating']) : '—' ?></td>
              <td class="text-muted small"><?= e((string)$p['lat']) ?>, <?= e((string)$p['lng']) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</main>
<?php include __DIR__ . '/includes/admin_layout_bottom.php'; ?>
