<?php
require_once __DIR__ . '/../includes/_init.php';
require_once __DIR__ . '/../../app/helpers.php';
require_once __DIR__ . '/../../app/db.php';

$pageTitle = "Admin Login";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $email = strtolower(trim($_POST['email'] ?? ''));
  $password = (string)($_POST['password'] ?? '');

  $pdo = db();
  $st = $pdo->prepare("SELECT id, name, password_hash FROM admins WHERE email=? LIMIT 1");
  $st->execute([$email]);
  $a = $st->fetch();

  if (!$a || !password_verify($password, $a['password_hash'])) {
    set_flash('danger', 'Invalid admin credentials.');
    redirect('/admin/login.php');
  }

  start_session();
  $_SESSION['admin_id'] = (int)$a['id'];
  $_SESSION['admin_name'] = $a['name'];
  set_flash('success', 'Welcome, ' . $a['name'] . '!');
  redirect('/admin/dashboard.php');
}

include __DIR__ . '/../includes/header.php';
?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-5">
      <div class="form-card p-4">
        <h3 class="fw-bold mb-1">Admin Login</h3>
        <div class="text-muted mb-4">Manage categories, users and trips.</div>

        <?php if ($flash): ?>
          <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
        <?php endif; ?>

        <form method="post" class="vstack gap-3">
          <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
          <div>
            <label class="form-label">Email</label>
            <input class="form-control" name="email" required placeholder="admin@smartguide.local">
          </div>
          <div>
            <label class="form-label">Password</label>
            <input type="password" class="form-control" name="password" required placeholder="Admin password">
          </div>
          <button class="btn btn-primary btn-lg">Login</button>
          <div class="small-note mt-2">
            Seed: <code>admin@smartguide.local</code> / <code>Admin@123</code>
          </div>
        </form>
      </div>
      <div class="text-center text-muted small mt-3">
        <a href="<?= BASE_URL ?>/index.php" class="text-muted text-decoration-underline">Back to landing</a>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
