<?php
require_once __DIR__ . '/includes/admin_init.php';
require_admin();

$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $action = $_POST['action'] ?? '';
  if ($action === 'create') {
    $name = trim($_POST['name'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    $kind = trim($_POST['otm_kind'] ?? '');
    $icon = trim($_POST['icon'] ?? '');
    $active = !empty($_POST['is_active']) ? 1 : 0;

    if ($name===''||$slug===''||$kind==='') {
      set_flash('danger','Name, slug and OTM kind are required.');
      redirect('/admin/categories.php');
    }
    $pdo->prepare("INSERT INTO categories (name,slug,otm_kind,icon,is_active) VALUES (?,?,?,?,?)")
        ->execute([$name,$slug,$kind,$icon?:null,$active]);
    set_flash('success','Category added.');
    redirect('/admin/categories.php');
  }

  if ($action === 'update') {
    $id = (int)($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    $kind = trim($_POST['otm_kind'] ?? '');
    $icon = trim($_POST['icon'] ?? '');
    $active = !empty($_POST['is_active']) ? 1 : 0;

    $pdo->prepare("UPDATE categories SET name=?, slug=?, otm_kind=?, icon=?, is_active=? WHERE id=?")
        ->execute([$name,$slug,$kind,$icon?:null,$active,$id]);
    set_flash('success','Category updated.');
    redirect('/admin/categories.php');
  }

  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    $pdo->prepare("DELETE FROM categories WHERE id=?")->execute([$id]);
    set_flash('success','Category deleted.');
    redirect('/admin/categories.php');
  }
}

$cats = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
$editId = (int)($_GET['edit'] ?? 0);
$edit = null;
if ($editId) {
  foreach ($cats as $c) if ((int)$c['id'] === $editId) $edit = $c;
}

$pageTitle = "Categories";
$active = "categories";
include __DIR__ . '/includes/admin_layout_top.php';
include __DIR__ . '/includes/admin_sidebar.php';
?>
<main class="admin-main">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-3">
    <div>
      <div class="text-muted small">Manage</div>
      <h2 class="fw-bold mb-0">Categories</h2>
    </div>
    <a class="btn btn-primary" href="<?= BASE_URL ?>/admin/categories.php#form"><i class="fa-solid fa-plus me-2"></i>Add Category</a>
  </div>

  <div class="card p-4 mb-3" id="form">
    <div class="h5 fw-semibold mb-3"><?= $edit ? 'Edit Category' : 'Add Category' ?></div>
    <form method="post" class="row g-3">
      <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
      <input type="hidden" name="action" value="<?= $edit ? 'update' : 'create' ?>">
      <?php if ($edit): ?><input type="hidden" name="id" value="<?= (int)$edit['id'] ?>"><?php endif; ?>

      <div class="col-md-4">
        <label class="form-label">Name</label>
        <input class="form-control" name="name" required value="<?= e($edit['name'] ?? '') ?>" placeholder="Cafe">
      </div>
      <div class="col-md-3">
        <label class="form-label">Slug</label>
        <input class="form-control" name="slug" required value="<?= e($edit['slug'] ?? '') ?>" placeholder="cafe">
      </div>
      <div class="col-md-3">
        <label class="form-label">OTM Kind</label>
        <input class="form-control" name="otm_kind" required value="<?= e($edit['otm_kind'] ?? '') ?>" placeholder="cafes">
      </div>
      <div class="col-md-2">
        <label class="form-label">Icon (FA)</label>
        <input class="form-control" name="icon" value="<?= e($edit['icon'] ?? '') ?>" placeholder="cup-hot">
      </div>

      <div class="col-12">
        <div class="form-check">
          <input class="form-check-input" type="checkbox" name="is_active" value="1" id="activeChk" <?= (!isset($edit) || ($edit && $edit['is_active'])) ? 'checked' : '' ?>>
          <label class="form-check-label" for="activeChk">Active</label>
        </div>
      </div>

      <div class="col-12 d-flex gap-2">
        <button class="btn btn-primary"><?= $edit ? 'Save Changes' : 'Add Category' ?></button>
        <?php if ($edit): ?>
          <a class="btn btn-outline-light" href="<?= BASE_URL ?>/admin/categories.php">Cancel</a>
        <?php endif; ?>
      </div>
      <div class="text-muted small">Hint: Use OpenTripMap kinds like <code>cafes</code>, <code>museums</code>, <code>historic</code>, <code>natural</code>.</div>
    </form>
  </div>

  <div class="card p-4">
    <div class="h5 fw-semibold mb-3">All Categories</div>
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead>
          <tr>
            <th>Name</th><th>Slug</th><th>OTM Kind</th><th>Status</th><th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($cats as $c): ?>
            <tr>
              <td class="fw-semibold"><?= e($c['name']) ?></td>
              <td class="text-muted"><?= e($c['slug']) ?></td>
              <td><code><?= e($c['otm_kind']) ?></code></td>
              <td><?= $c['is_active'] ? '<span class="badge bg-success-subtle text-success border border-success-subtle">Active</span>' : '<span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle">Off</span>' ?></td>
              <td class="text-end">
                <a class="btn btn-outline-light btn-sm" href="<?= BASE_URL ?>/admin/categories.php?edit=<?= (int)$c['id'] ?>#form">Edit</a>
                <form method="post" class="d-inline">
                  <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
                  <input type="hidden" name="action" value="delete">
                  <input type="hidden" name="id" value="<?= (int)$c['id'] ?>">
                  <button class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete this category?')">Delete</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</main>
<?php include __DIR__ . '/includes/admin_layout_bottom.php'; ?>
