<?php
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../config.php';

class RouteService {

    // ORS expects coords as [lng,lat]
    public static function matrix(array $coordsLngLat): array {
        if (!ORS_API_KEY || ORS_API_KEY === 'YOUR_OPENROUTESERVICE_API_KEY') {
            throw new Exception('OpenRouteService API key missing. Please set ORS_API_KEY in app/config.php');
        }
        $url = "https://api.openrouteservice.org/v2/matrix/driving-car";
        $payload = json_encode([
            'locations' => $coordsLngLat,
            'metrics' => ['duration', 'distance'],
        ]);

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => [
                'Authorization: ' . ORS_API_KEY,
                'Content-Type: application/json',
                'Accept: application/json',
            ],
        ]);
        $raw = curl_exec($ch);
        $err = curl_error($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($raw === false) throw new Exception('ORS matrix request failed: ' . $err);
        if ($code >= 400) throw new Exception('ORS matrix HTTP error ' . $code . ': ' . $raw);

        $data = json_decode($raw, true);
        if ($data === null) throw new Exception('ORS matrix invalid JSON.');

        return $data; // contains durations[][] and distances[][]
    }

    public static function directions(array $orderedCoordsLngLat): array {
        if (!ORS_API_KEY || ORS_API_KEY === 'YOUR_OPENROUTESERVICE_API_KEY') {
            throw new Exception('OpenRouteService API key missing. Please set ORS_API_KEY in app/config.php');
        }
        $url = "https://api.openrouteservice.org/v2/directions/driving-car/geojson";
        $payload = json_encode([
            'coordinates' => $orderedCoordsLngLat,
        ]);

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 25,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => [
                'Authorization: ' . ORS_API_KEY,
                'Content-Type: application/json',
                'Accept: application/json',
            ],
        ]);
        $raw = curl_exec($ch);
        $err = curl_error($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($raw === false) throw new Exception('ORS directions request failed: ' . $err);
        if ($code >= 400) throw new Exception('ORS directions HTTP error ' . $code . ': ' . $raw);

        $data = json_decode($raw, true);
        if ($data === null) throw new Exception('ORS directions invalid JSON.');

        return $data; // geojson feature collection
    }
}
