# Smart Tourist Guide (PHP + MySQL) — Minor Project (Business UI)

A complete **Smart Tourist Guide** web app with:
- User signup/login, profile, saved trips
- City validation via **OpenStreetMap Nominatim**
- Place discovery via **OpenTripMap API**
- Route optimization using **OpenRouteService Matrix + Directions**
- Auto itinerary schedule builder
- Interactive map via **Leaflet + OpenStreetMap**
- Admin panel with professional sidebar dashboard (categories/users/trips)

> **Seed credentials**
- Admin: `admin@smartguide.local` / `Admin@123`
- User: `demo@smartguide.local` / `User@123`

---

## 1) Requirements
- PHP **8.0+**
- MySQL **5.7+ / 8.0**
- Apache (recommended) or Nginx
- cURL enabled in PHP

## 2) Setup (XAMPP/WAMP/LAMP)
1. Create a MySQL database, e.g. `smart_tourist_guide`
2. Import schema + seed:
   - `database/schema.sql`
   - `database/seed.sql`
3. Update credentials + API keys:
   - Copy `app/config.sample.php` → `app/config.php`
   - Edit `app/config.php`

## 3) API Keys (Free-friendly stack)
This project uses **Option A** stack:
- Geocoding: **Nominatim** (no key required; use responsibly)
- Places: **OpenTripMap** (requires API key)
- Routing/Matrix: **OpenRouteService** (requires API key)

Add these to `app/config.php`:
- `OTM_API_KEY`
- `ORS_API_KEY`

## 4) Run
- Put folder in your server root (e.g. `htdocs/smart-tourist-guide`)
- Open:
  - Landing page: `/public/index.php`
  - Admin: `/public/admin/login.php`
  - User app: `/public/auth/login.php`

## 5) Notes
- For minor-project simplicity, the trip duration is 1 day.
- Nearest-neighbor heuristic is used for route ordering (practical and complete).
- If routing/matrix APIs fail or keys are missing, the UI shows an actionable error.

---

## Project Structure
- `public/` — web root
- `app/` — PHP backend (DB, services, helpers)
- `database/` — schema + seed
- `storage/` — cached responses and logs (writable)

---

## Security (baseline)
- Passwords stored with `password_hash()` (bcrypt)
- Prepared statements (PDO)
- CSRF tokens for POST forms
- Session-based authentication

Enjoy ✅
